/*
 * Decompiled with CFR 0.152.
 */
package com.log;

import com.dto.LoginDto;
import com.log.CachedBodyHttpServletRequest;
import com.log.LogRepository;
import com.log.RequestLog;
import java.time.LocalDateTime;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/log/RequestLoggingFilter;", "Ljavax/servlet/Filter;", "logRepository", "Lcom/log/LogRepository;", "(Lcom/log/LogRepository;)V", "doFilter", "", "request", "Ljavax/servlet/ServletRequest;", "response", "Ljavax/servlet/ServletResponse;", "chain", "Ljavax/servlet/FilterChain;", "TNCHolooWebService"})
@SourceDebugExtension(value={"SMAP\nRequestLoggingFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestLoggingFilter.kt\ncom/log/RequestLoggingFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public class RequestLoggingFilter
implements Filter {
    @NotNull
    private final LogRepository logRepository;

    public RequestLoggingFilter(@NotNull LogRepository logRepository) {
        Intrinsics.checkNotNullParameter((Object)logRepository, (String)"logRepository");
        this.logRepository = logRepository;
    }

    public void doFilter(@Nullable ServletRequest request, @Nullable ServletResponse response, @Nullable FilterChain chain) {
        try {
            String uri;
            CachedBodyHttpServletRequest cachedBodyHttpServletRequest;
            HttpServletRequest httpRequest;
            HttpServletRequest httpServletRequest = httpRequest = (HttpServletRequest)request;
            if (httpServletRequest != null) {
                HttpServletRequest it = httpServletRequest;
                boolean bl = false;
                cachedBodyHttpServletRequest = new CachedBodyHttpServletRequest(it);
            } else {
                cachedBodyHttpServletRequest = null;
            }
            CachedBodyHttpServletRequest wrappedRequest = cachedBodyHttpServletRequest;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            long start = System.currentTimeMillis();
            FilterChain filterChain = chain;
            if (filterChain != null) {
                filterChain.doFilter((ServletRequest)wrappedRequest, response);
            }
            CachedBodyHttpServletRequest cachedBodyHttpServletRequest2 = wrappedRequest;
            String string = uri = cachedBodyHttpServletRequest2 != null ? cachedBodyHttpServletRequest2.getRequestURI() : null;
            boolean bl = string != null ? !StringsKt.contains$default((CharSequence)string, (CharSequence)"companies", (boolean)false, (int)2, null) : false;
            if (bl && StringsKt.contains$default((CharSequence)uri, (CharSequence)"android", (boolean)false, (int)2, null)) {
                Object principal;
                long duration = System.currentTimeMillis() - start;
                String method = wrappedRequest.getMethod();
                String ip = wrappedRequest.getRemoteAddr();
                HttpServletResponse httpServletResponse = httpResponse;
                Integer status = httpServletResponse != null ? Integer.valueOf(httpServletResponse.getStatus()) : null;
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                if (auth != null && auth.isAuthenticated() && (principal = auth.getPrincipal()) instanceof LoginDto) {
                    String string2 = method;
                    if (string2 == null) {
                        string2 = "";
                    }
                    String string3 = string2;
                    Integer n = status;
                    int n2 = n != null ? n : 0;
                    int n3 = ((LoginDto)principal).userCodeInc;
                    LocalDateTime localDateTime = LocalDateTime.now();
                    String string4 = ((LoginDto)principal).userName;
                    Intrinsics.checkNotNull((Object)ip);
                    Intrinsics.checkNotNull((Object)localDateTime);
                    Intrinsics.checkNotNull((Object)string4);
                    RequestLog log = new RequestLog(0, n3, string3, uri, ip, n2, duration, localDateTime, string4);
                    this.logRepository.saveNoneLoginLog(log);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

